package org.msh.etbm.services.mobile.init;

import org.jboss.seam.Component;
import org.msh.etbm.rest.mobile.SyncFromServerRequest;
import org.msh.etbm.services.mobile.InitAndSyncDataGenerator;
import org.msh.etbm.services.mobile.model.TbCaseData;
import org.msh.tb.entities.Address;
import org.msh.tb.entities.FieldValueComponent;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.ng.entities.TbCaseNG;

import javax.persistence.EntityManager;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by rmemoria on 20/4/17.
 */
public class Step3InitGenerator implements InitAndSyncDataGenerator<List<TbCaseData>> {

    @Override
    public List<TbCaseData> generate(Tbunit unit) {
        return generate(unit, null);
    }

    @Override
    public List<TbCaseData> generate(Tbunit unit, SyncFromServerRequest req) {
        EntityManager em = (EntityManager) Component.getInstance("entityManager");

        String qryString = "from TbCaseNG where ownerUnit.id = :id ";

        if (req != null && req.hasBothIndexes()) {
            qryString += " and lastTransaction.id > " + req.getServerIndexFrom();
            qryString += " and lastTransaction.id <= " + req.getServerIndexTo();
        }

        List<TbCaseNG> lst = em
                .createQuery(qryString)
                .setParameter("id", unit.getId())
                .getResultList();

        List<TbCaseData> res = new ArrayList<TbCaseData>();

        for (TbCaseNG tbcase: lst) {
            res.add(convertData(tbcase));
        }
        return res;
    }

    public static TbCaseData convertData(TbCaseNG tbcase) {
        TbCaseData data = new TbCaseData();
        data.setServerId(tbcase.getId());
        data.setPatientId(tbcase.getPatient().getId());
        data.setCaseNumber(tbcase.getDisplayCaseNumber());
        data.setName(tbcase.getPatient().getName());
        data.setMiddleName(tbcase.getPatient().getMiddleName());
        data.setLastName(tbcase.getPatient().getLastName());
        data.setMotherName(tbcase.getPatient().getMotherName());
        data.setBirthDate(tbcase.getPatient().getBirthDate());
        data.setAge(tbcase.getAge());
        data.setGender(tbcase.getPatient().getGender());
        data.setSecurityNumber(tbcase.getPatient().getSecurityNumber());
        data.setClassification(tbcase.getClassification());
        data.setState(tbcase.getState());
        data.setValidationState(tbcase.getValidationState());
        data.setPatientType(tbcase.getPatientType());
        data.setCaseDefinition(tbcase.getCaseDefinition());
        data.setDiagnosisType(tbcase.getDiagnosisType());
        data.setInfectionSite(tbcase.getInfectionSite());
        data.setPulmonaryId(tbcase.getPulmonaryType() != null ? tbcase.getPulmonaryType().getId() : null);
        data.setExtrapulmonaryId(fieldValue(tbcase.getExtrapulmonaryType()));
        data.setExtrapulmonary2Id(fieldValue(tbcase.getExtrapulmonaryType2()));
        data.setRegistrationDate(tbcase.getRegistrationDate());
        data.setHealthunitRegistrationDate(tbcase.getRegistrationDate());
        data.setDiagnosisDate(tbcase.getDiagnosisDate());
        if (tbcase.isOnTreatment()) {
            data.setIniTreatmentDate(tbcase.getTreatmentPeriod().getIniDate());
            data.setEndTreatmentDate(tbcase.getTreatmentPeriod().getEndDate());
        }
        data.setOutcomeDate(tbcase.getOutcomeDate());
        data.setIniContinuousPhase(tbcase.getIniContinuousPhase());
        data.setRegimenId(tbcase.getRegimen() != null ? tbcase.getRegimen().getId() : null);
        data.setRegimenIniId(tbcase.getRegimenIni() != null ? tbcase.getRegimenIni().getId() : null);
        data.setMaritalStatus(tbcase.getMaritalStatus().getValue() != null ? tbcase.getMaritalStatus().getValue().getId() : null);
        data.setOccupation(tbcase.getOccupation().getValue() != null ? tbcase.getOccupation().getValue().getId() : null);
        data.setDrugResistanceType(tbcase.getDrugResistanceType());

        Address addr = tbcase.getNotifAddress();
        data.setAddress(addr.getAddress());
        data.setZipCode(addr.getZipCode());
        data.setAdminUnitId(addr.getAdminUnit() != null ? addr.getAdminUnit().getId() : null);
        data.setMobileNumber(tbcase.getMobileNumber());
        data.setPhoneNumber(tbcase.getPhoneNumber());
        data.setEmailAddress(tbcase.getEmailAddress());

        data.setTbRegistrationNumber(tbcase.getTbRegistrationNumber());

        data.setHivPosition(tbcase.getHivPosition());
        data.setHivPositionDetail(tbcase.getHivPositionDetail());

        data.setIntakeAntiTBDrugs(tbcase.getIntakeAntiTBDrugs() != null ? tbcase.getIntakeAntiTBDrugs().isYes() : false);
        data.setIntakeAntiTBDrugsDuration(tbcase.getIntakeAntiTBDrugsDuration());
        data.setSourceReferralId(fieldValue(tbcase.getSourceReferral()));
        data.setDotProvider(fieldValue(tbcase.getDotProvider()));
        data.setTreatmentCategory(tbcase.getTreatmentCategory());
        data.setMovedSecondLineTreatment(tbcase.isMovedSecondLineTreatment());
        data.setNationality(tbcase.getNationality());

        return data;
    }

    private static Integer fieldValue(FieldValueComponent fld) {
        if (fld == null) {
            return null;
        }

        return fld.getValue() != null ? fld.getValue().getId() : null;
    }
}
